clear all;
close all;

A = importdata('4.5T_Sweep_Up.dat');
Data(:,1) = A(:,2);
Data(:,2) = A(:,3);
R_0T = A(:,2);
T_0T = A(:,3);

dy = diff(R_0T);
n = size(dy);
j = 1;

figure;
plot(Data(:,2),Data(:,1))

for i = 1:n
    if dy(i) < -0.05
       Transition(j,1) = T_0T(i+1);
       Transition(j,2) = R_0T(i+1);
       j = j + 1;        
    end
end

figure;
plot(Transition(:,1),Transition(:,2));

Tc_R = (max(Transition(:,2)) - min(Transition(:,2)))/2;
n = size(Transition,1);

for i = 1:n
    if Transition(i,2) < Tc_R
        Tc = Transition(i,1)
        break
    else
    end
end

Tc;